package com.agilex.healthcare.directscheduling.domain;


import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;

@XmlAccessorType(value= XmlAccessType.NONE)
@XmlRootElement(name="AppointmentTimeSlot", namespace = Namespace.DirectScheduling)
public class AppointmentTimeSlot{

    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date startDateTime;

    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date endDateTime;

    @XmlElement
    private String bookingStatus;

    @XmlElement
    private String remainingAllowedOverBookings;

    @XmlElement
    private boolean availability;


    public Date getStartDateTime() {
        return startDateTime;
    }

    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Date getEndDateTime() {
        return endDateTime;
    }

    public void setEndDateTime(Date endDateTime) {
        this.endDateTime = endDateTime;
    }

    public String getBookingStatus() {
        return bookingStatus;
    }

    public void setBookingStatus(String bookingStatus) {
        this.bookingStatus = bookingStatus;
    }

    public String getRemainingAllowedOverBookings() {
        return remainingAllowedOverBookings;
    }

    public void setRemainingAllowedOverBookings(String remainingAllowedOverBookings) {
        this.remainingAllowedOverBookings = remainingAllowedOverBookings;
    }

    public boolean isAvailability() {
        return availability;
    }

    public void setAvailability(boolean availability) {
        this.availability = availability;
    }
}
